<?php
// JIT
/**
 * Callback function to modify buffer
 *
 * @param mixed $buffer
 * @return mixed
 */
function structeezy_buffer_callback( $buffer ) {
	$add_code  = '<!-- Structeezy -->' . PHP_EOL;
	$add_code .= '<style>body{background:aquamarine}</style>' . PHP_EOL;
	$add_code .= '<!-- End Structeezy -->' . PHP_EOL;
	// insert $add_code in $buffer just before '</head>, and then return the updated code.
	return str_replace( '</head>', $add_code . '</head>', $buffer );
}

ob_start();

add_action(
	'shutdown',
	function() {
		$final = '';

		// We'll need to get the number of ob levels we're in, so that we can iterate over each, collecting
		// that buffer's output into the final output.
		$levels = ob_get_level();

		for ( $i = 0; $i < $levels; $i++ ) {
			$final .= ob_get_clean();
		}

		// Apply any filters to the final output
		echo apply_filters( 'final_output', $final );
	},
	0
);

add_filter( 'final_output', 'structeezy_buffer_callback' );
